using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    const long INF = (long)1e18;

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());

        long[] x = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] h = Console.ReadLine().Split().Select(long.Parse).ToArray();

        // spakuj i sortiraj po x
        var p = new List<(long x, long h, int id)>();
        for (int i = 0; i < n; i++)
            p.Add((x[i], h[i], i));

        p = p.OrderBy(t => t.x).ToList();

        long[] X = new long[n];
        long[] H = new long[n];
        for (int i = 0; i < n; i++)
        {
            X[i] = p[i].x;
            H[i] = p[i].h;
        }

        // prvi visi levo i desno
        int[] L = new int[n];
        int[] R = new int[n];
        Array.Fill(L, -1);
        Array.Fill(R, -1);

        // === LEVI STEK ===
        Stack<int> st = new Stack<int>();
        for (int i = 0; i < n; i++)
        {
            while (st.Count > 0 && H[st.Peek()] < H[i])
                st.Pop();

            if (st.Count > 0) L[i] = st.Peek();
            st.Push(i);
        }

        // === DESNI STEK ===
        st.Clear();
        for (int i = n - 1; i >= 0; i--)
        {
            while (st.Count > 0 && H[st.Peek()] < H[i])
                st.Pop();

            if (st.Count > 0) R[i] = st.Peek();
            st.Push(i);
        }

        // racunamo odgovor
        long[] ans = new long[n];
        for (int i = 0; i < n; i++)
        {
            long best = INF;

            if (L[i] != -1)
                best = Math.Min(best,
                    Math.Abs(X[i] - X[L[i]]) - (H[L[i]] - H[i]));

            if (R[i] != -1)
                best = Math.Min(best,
                    Math.Abs(X[R[i]] - X[i]) - (H[R[i]] - H[i]));

            ans[i] = (best == INF ? -1 : best);
        }

        // ispis u originalnom redosledu
        long[] outp = new long[n];
        for (int i = 0; i < n; i++)
            outp[p[i].id] = ans[i];

        for (int i = 0; i < n; i++)
            Console.WriteLine(outp[i]);
    }
}